<?php

namespace Sentinel\Controllers;

use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\Response;
use Sentinel\FormRequests\LoginRequest;
use Sentinel\Repositories\Session\SentinelSessionRepositoryInterface;
use Sentinel\Traits\SentinelRedirectionTrait;
use Sentinel\Traits\SentinelViewfinderTrait;
use Cartalyst\Sentry\Users\UserNotFoundException;
use Sentry;
use View;
use Request;
use Event;
use Redirect;
use Session;
use Config;
use DB;
use App\Direccion;

ini_set('memory_limit', '-1');
//ini_set('max_execution_time', 580000000);
//ini_set("soap.wsdl_cache_enabled", 0);
//init_set("soap.wsdl_cache_dir", '/tmp');
//ini_set("soap.wsdl_cache_ttl", 0);
//ini_set('display_errors', true);
error_reporting(E_ALL);
ini_set('display_errors', 'On');


class SessionController extends BaseController
{
    /**
     * Traits
     */
    use SentinelRedirectionTrait;
    use SentinelViewfinderTrait;

    /**
     * Constructor
     */
    public function __construct(SentinelSessionRepositoryInterface $sessionManager)
    {
        $this->session = $sessionManager;
    }

    /**
     * Show the login form
     */
    public function create()
    {
        // Is this user already signed in?
        if (Sentry::check()) {
            return $this->redirectTo('session_store');
        }

        // No - they are not signed in.  Show the login form.
        return $this->viewFinder(config('sentinel.view.session_login', 'Sentinel::sessions.login'));
    }

    /**
     * Attempt authenticate a user.
     *
     * @return Response
     */
    public function store(LoginRequest $request)
    {
        
       
        $username = $request->email;
        $password2 = $request->password;
        
    
        
   
        
        
        
  
        
        
    
                   try
{
$usuarioActualizar=Sentry::findUserByLogin($username);
//$groups = $usuarioActualizar->getGroups();




        }
catch (UserNotFoundException $e)
{
    $usuarioActualizar="null";
    
        include(app_path() . '/lib/nusoap.php');

        $usuario="conermex";
        $password="c0n3rm3x61!";
        $numempresa="8306";
        $oSoapClient = new \nusoap_client('https://www.clickbalance.net/click/wsCFD.php?wsdl', true);
        $cliente = $oSoapClient->call("getClienteByRfc", array ('usuario' => $usuario, 'password' => $password, 'empresa' => $numempresa, 'rfc'=>$username));
        $err = $oSoapClient->getError();
       
       // $err2 = $oSoapClient2->getError();
        //$user= DB::table('users')->where('email','=',$username)->get();
        
        
        if($cliente['resultado'] != '405'){    
        $user2 = Sentry::createUser(array(
        'email'     =>  $username,
        'password'  => $cliente['datos'][0]['rfc']."-".$cliente['datos'][0]['numero'],
        'first_name' =>$cliente['datos'][0]['nombre'],
        'last_name'=>$cliente['datos'][0]['apellido_paterno']." ".$cliente['datos'][0]['apellido_materno'],
        'activated' => true,
        'descuento'=>$cliente['datos'][0]['descuento_cliente'],
        'credito'=>$cliente['datos'][0]['plazo_cliente'],
        'idAgente'=>$cliente['datos'][0]['agente_cliente'],
        'idclickBalance'=>$cliente['datos'][0]['id']
    )); 
    
    $direccion = DB::table('direccions')->where('rfc','=',$username)->get();
      if(sizeof($direccion)==0){
          
        
            $oSoapClient2 = new \nusoap_client('https://www.clickbalance.net/click/wsCFD.php?wsdl', 'wsdl');
       // $direcciones = $oSoapClient2->call("getDirecciones", array ('usuario' => $usuario, 'password' => $password, 'empresa' => $numempresa, 'fechahora'=>"0000-00-00|2000|0"));
       
       
         $direcciones = $oSoapClient2->call("getDirecciones", array ('usuario' => $usuario, 'password' => $password, 'empresa' => $numempresa, 'fechahora'=>"0000-00-00|2000|0"));
        
        for($i=0; $i<sizeof($direcciones['datos']); $i++){
            
        if( $direcciones['datos'][$i]['idasociado'] == $cliente['datos'][0]['id'] && $direcciones['datos'][$i]['es_domicilio_fiscal'] == 1 ){
         
        
            
            $direc = new Direccion;
            $direc->idAsociado = $direcciones['datos'][$i]['idasociado'];
            $direc->rfc = $cliente['datos'][0]['rfc'];
            $direc->calle = $direcciones['datos'][$i]['calle'];
            $direc->colonia = $direcciones['datos'][$i]['colonia'];
            $direc->localidad = $direcciones['datos'][$i]['localidad'];
            $direc->codigopostal= $direcciones['datos'][$i]['codigo_postal'];
            $direc->nombre_estado= $direcciones['datos'][$i]['municipio'];
            $direc->numero_interior= $direcciones['datos'][$i]['numero_interior'];
            $direc->numero_exterior= $direcciones['datos'][$i]['numero_exterior'];
            $direc->pais= $direcciones['datos'][$i]['pais'];
            $direc->telefono=$direcciones['datos'][$i]['telefono'];
            $direc->save();
            
        }
            
            
                
            }
        }
        
        
        $oSoapClient3 = new \nusoap_client('https://www.clickbalance.net/click/wsCFD.php?wsdl', true);
   $contacto = $oSoapClient3->call("getContactos", array ('usuario' => $usuario, 'password' => $password, 'empresa' => $numempresa, 'anio'=>0, 'mes'=>0,'dia'=>0, 'ultimo_id'=>0));
    $err = $oSoapClient3->getError();

            
            $usuarioActualizar2=Sentry::findUserByLogin($user2->email);
            for($i=0; $i<sizeof($contacto['datos']); $i++){
                if($contacto['datos'][$i]['asociado_id'] == $user2->idclickBalance){
                    
                    $usuarioActualizar2->correo=$contacto['datos'][$i]['email'];
                    $usuarioActualizar2->update();
                    
                }
                
            }
        
        
    
    
}else{
    return redirect('/login')->with('message', 'Usuario o contraseña incorrecto');
}
    
    
    
    //return Redirect::to('/login');
}       
 


   //if( $cliente['resultado'] != '405' && $usuarioActualizar !="null" && !$usuarioActualizar->hasAccess('admin') && !$usuarioActualizar->hasAccess('almacenista')){
        
        /*
            
            $usuarioActualizar->first_name =$cliente['datos'][0]['nombre'];
            $usuarioActualizar->last_name =$cliente['datos'][0]['apellido_paterno'].$cliente['datos'][0]['apellido_materno'];
            $usuarioActualizar->descuento=$cliente['datos'][0]['descuento_cliente'];
            $usuarioActualizar->credito=$cliente['datos'][0]['plazo_cliente'];
            $usuarioActualizar->idAgente=$cliente['datos'][0]['agente_cliente'];
            $usuarioActualizar->idclickBalance=$cliente['datos'][0]['id'];
            
            $usuarioActualizar->update();
            */
            
             //$oSoapClient2 = new \nusoap_client('https://www.clickbalance.net/click/wsCFD.php?wsdl', true);
        //$direcciones = $oSoapClient2->call("getDirecciones", array ('usuario' => $usuario, 'password' => $password, 'empresa' => $numempresa, 'fechahora'=>"0000-00-00|2000|0"));
        //$direcciones = $oSoapClient2->call("getDirecciones", array ('usuario' => $usuario, 'password' => $password, 'empresa' => $numempresa, 'fechahora'=>"0000-00-00|100|0"));
        
            
        
         
            
            
            
            
            
       // }
        
      
        
    
        
       
        // Gather the input
        $data = $request->all();

        // Attempt the login 
        $result = $this->session->store($data);

        // Did it work?
        if ($result->isSuccessful()) {
            // Login was successful.  Determine where we should go now.
            if (!config('sentinel.views_enabled')) {
                // Views are disabled - return json instead
                return Response::json('success', 200); 
            }
            // Views are enabled, so go to the determined route
            $redirect_route = config('sentinel.routing.session_store');
            
            
        
       
            

            return Redirect::intended($this->generateUrl($redirect_route));
        } else {
            // There was a problem - unrelated to Form validation.
            if (!config('sentinel.views_enabled')) {
                // Views are disabled - return json instead
                return Response::json($result->getMessage(), 400);
            }
            Session::flash('error', $result->getMessage());

            return Redirect::route('sentinel.session.create')
                ->withInput();
        }
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @return Response
     */
    public function destroy()
    {
        $this->session->destroy();

        return Redirect::to('/login');
    }
}
